package doABC;

import java.nio.ByteBuffer;
import java.util.*;

import doABC.Trait.*;
import FlashReader.*;


public class TraitInfo extends SwfTools {
	
	private int id;
	private HashMap<Integer, String> flagsKind = new HashMap<Integer, String>();
	private CpoolInfo cpool;
	private AbcFile abc;
	private String attribute;
	private String dataDesription ="";	
	
	private int start=0;
	private int end=0;
	//struktory
	private int name;
	private int kind;//u8
	private Object data = null;//optional
	private int metadata_count=-1; //optional
	private ArrayList<Integer> metadata = new ArrayList<Integer>();

	public TraitInfo(AbcFile abc,int name, int kind, Object data, int metadata_count, ArrayList<Integer> metadata){
		super();
		initFlags();
		this.abc = abc;
		this.cpool = abc.getConstant_pool();
		this.name = name;
		this.kind = kind;
		this.data = data;
		this.metadata_count = metadata_count;
		
		if (metadata_count >0 ){
			this.metadata =metadata;
		}
		
		abc.ENtrait_info.add(this);
		id = abc.ENtrait_info.size()-1;
		
	}
	
	
	public TraitInfo(AbcFile abc,ByteBuffer bbuf){
		super();
		initFlags();
		this.abc = abc;
		this.cpool = abc.getConstant_pool();
		traits_info(bbuf);
		
		abc.ENtrait_info.add(this);
		id = abc.ENtrait_info.size()-1;
	}

	public void initFlags(){
		flagsKind.put(0x00, "TRAIT_Slot");
		flagsKind.put(0x01, "TRAIT_Method");
		flagsKind.put(0x02, "TRAIT_Getter");
		flagsKind.put(0x03, "TRAIT_Setter");
		flagsKind.put(0x04, "TRAIT_Class");
		flagsKind.put(0x05, "TRAIT_Function");
		flagsKind.put(0x06, "TRAIT_Const");
	}

	public void traits_info(ByteBuffer bbuf){
		try{
		start = bbuf.position();
		
		name = unsigned30int(bbuf);
		
		kind = unsignedByte(bbuf.get());
		
		int tag = kind & 0xf;
		int tag2 = kind & 0xf0;
		
		switch(tag) {
			case 0x00:
			case 0x06:
				data =new Trait_Slot_Const(bbuf,cpool);
				abc.constNames.add(getName_string());
				dataDesription=Trait_Slot_Const.class.getName();
				break;
			case 0x01:
			case 0x02:
			case 0x03:
				Trait_method_getter_setter tr=new Trait_method_getter_setter(bbuf);
				data=tr;
				
				int id =tr.getMethod();
				String s =getName_string();
				abc.methodsNames.put( id,s);
				dataDesription=Trait_method_getter_setter.class.getName();
				if(tag2 ==0x10) attribute= "ATTR_Final";
				if(tag2 ==0x20) attribute= "ATTR_Override";
				
				break;
			case 0x04:
				Trait_class tc = new Trait_class(bbuf);
				data=tc;
				
				String s1 =getName_string();
				
				int idClass =tc.getClassi();
				
				if (abc.ClassNames.size() < idClass+1)
					abc.ClassNames.setSize(idClass+1);
				
				abc.ClassNames.setElementAt(s1, idClass);
				
				dataDesription=Trait_class.class.getName();
				break;
			case 0x05:
				data=new Trait_function(bbuf);
				dataDesription=Trait_function.class.getName();
				break;	
		}
		if (tag2 == 0x40){
			attribute= "ATTR_Metadata";
			
			metadata_count = unsigned30int(bbuf);
			
			for (int i=0;i<metadata_count; i++)
				metadata.add(unsigned30int(bbuf));
		}
		end = bbuf.position()-1;
	} catch (Exception e) {e.printStackTrace();}
	}
	
	
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			for (byte b: getUI32(name))
				result.add(b);

			result.add((byte)kind);
		
		if(data != null){
			if(dataDesription.equals(Trait_Slot_Const.class.getName())){
				ArrayList<Byte> tmp =((Trait_Slot_Const)data).toByteCode();
				for (int i=0;i<tmp.size();i++){
						result.add(tmp.get(i));
				}
			}else if(dataDesription.equals(Trait_method_getter_setter.class.getName())){
				for (byte b: ((Trait_method_getter_setter)data).toByteCode())
					result.add(b);
			}else if(dataDesription.equals(Trait_class.class.getName())){
				for (byte b: ((Trait_class)data).toByteCode())
					result.add(b);
			}else if(dataDesription.equals(Trait_function.class.getName())){
				for (byte b: ((Trait_function)data).toByteCode())
					result.add(b);
			}	
		}
		
		if (  metadata_count!=-1){
			for (byte b: getUI32(metadata_count))
				result.add(b);
		}
		
		if (  metadata_count!=-1){
			for (int i=0;i<metadata.size();i++){
				for (byte b: getUI32(metadata.get(i)))
					result.add(b);
			}			
		}
		
		return result;
	}

	
	//getters
	
	public int getId() {
		return id;
	}

	public void setFlagsKind(HashMap<Integer, String> flagsKind) {
		this.flagsKind = flagsKind;
	}

	public HashMap<Integer, String> getFlagsKind() {
		return flagsKind;
	}

	public int getFlags(String flags) {
		return (Integer)getKeyFromValue(flagsKind, flags);
	}
	
	
	public Object getData() {
		return data;
	}

	public int getMetadata_count() {
		return metadata_count;
	}

	public ArrayList<Integer> getMetadata() {
		return metadata;
	}

	public int getKind() {
		return kind;
	}
	
	public String getKind_string() {
		return flagsKind.get(kind);
	}
	

	public int getName() {
		return name;
	}


	//setters
	
	public void setName(int name) {
		this.name = name;
	}
	
	//toStrings
	public String getName_string() {
		return  cpool.getMultiname(name);
	}
	
	public String String(){
		StringBuffer wynik = new StringBuffer();
		
		wynik.append( ">" + start +"\n" );
		wynik.append( "name: " +getName_string() +"\n" );
		wynik.append( "kind: " + kind +"\n" );
		
		wynik.append( "data: " + data +"\n" );
		
		wynik.append( "metadata_count: " + metadata_count +"\n" );
		
		wynik.append( "metadata: " + metadata +"\n" );
		wynik.append( "attribute: " + attribute +"\n" );

		wynik.append( "<" + end +"\n" );
		
		return wynik.toString();
	}
	
	public String toString(){
		String wynik ="";
		wynik+="trait_info id " + id + " " +start+ " - " + end;
		return wynik;
	}
	
	
	
}
